/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package export;

import java.io.File;
import java.io.FileOutputStream;

import com.inet.report.Engine;

/**
 * This sample demonstrates how you can export a report to all supported output formats, excepting HTML. If you like to
 * export to HTML then refer to the sample file "samples/export/ExportWithoutViewerToHTML.java".
 */
public class ExportWithoutViewer {

    /**
     * Runs a simple export of a report file using RDC methods.
     * @param reportFile location of report file
     * @param exportFile location of file to export to
     */
    public ExportWithoutViewer( String reportFile, String exportFile ) {
        try {
            Engine eng = new Engine( Engine.EXPORT_PDF ); // Set the export format e.g. PDF
            eng.setReportFile( reportFile );
            // Set values for needed parameters
            // eng.setPassword("...");
            // eng.setPrompt("...","...");
            eng.execute();
            File pdfFile = new File( exportFile );
            FileOutputStream fos = new FileOutputStream( pdfFile );
            for( int i = 1; i <= eng.getPageCount(); i++ ) {
                fos.write( eng.getPageData( i ) );
            }
            fos.close();
        } catch( Throwable t ) {
            t.printStackTrace();
        }
    }

    /**
     * Main method, runs the sample
     * @param args first parameter: report file, second parameter: export file
     */
    public static void main( String[] args ) {
        if( args == null || args.length != 2 ) {
            System.out.println( "Usage: ExportWithoutViewer <Report File> <Export File>" );
            System.exit( 1 );
        }
        new ExportWithoutViewer( args[0], args[1] );
    }
}
